              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : MC56F8006 Modular Pixel Matrix                               *
*  Version    : 0.1                                                          *
*  Date       : 27/Apr/2009                                                  *
*  Engineers  : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: rs485.c	                                                         *
*                                                                            *
*    MC56F8006 RS485														 * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#include "rs485.h"
#include "MC56f8006.h"

typedef unsigned char byte;

/****************************** Prototypes ***********************************/

/**
 * TERMIO_PutChar:   This function sends a character through the SPI. 
 *
 * Parameters:    character to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_PutChar(int8_t send) 
{
  int8_t dummy;
  
  while(!(SCI_STAT & SCI_STAT_TDRE)){}
  
  	
  
  dummy = SCI_STAT;
  SCI_DATA  = send;    
}//end TERMIO_PutChar


/**
 * TERMIO_GetChar:   This function receives a character through the SPI 
 *
 * Parameters:    none
 *
 * Subfunctions:  none.
 *
 * Return:        character recieved
 */ 

int8_t TERMIO_GetChar(void) 
{
  int8_t dummy, teste;
  byte rec_char;
  
  if (SCI_STAT_RDRF)  // 1st half of RDRF clear procedure
    rec_char = SCI_DATA; 
  
  SCI_CTRL1|=SCI_CTRL1_RE;
  
  while(! (SCI_STAT & SCI_STAT_RDRF)){}
  dummy = SCI_STAT;
  teste=SCI_DATA;
  TERMIO_PutChar(teste);
  
  return SCI_DATA;  
} //end TERMIO_GetChar 


/**
 * TERMIO_Print:   This function sends a character string ended with 0 through the SCI
 *
 * Parameters:    character to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_Print(int8_t * str ) 
{ 
	uint8_t dummy;
	
	while(*str) 
	{
	  while( !(SCI_STAT & SCI_STAT_TDRE) ){}
	 // dummy = SCI_STAT;
	  SCI_DATA  = *str++;    		
	}
  
}//end TERMIO_PutChar


/**
 * TERMIO_PrintDigit:   This function sends a digit number through the SCI
 *
 * Parameters:    number to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_PrintDigit(uint16_t number  ) 
{ 
	uint8_t dummy;
	uint8_t buf[4];
	int8_t  i = 0;
	
	for(i = 0; i < 4; i++)
	{
		buf[i] = (number>>(i<<2)) & 0x000f;
		if(buf[i] >= 0 && buf[i] <= 9)
		{
			buf[i] += '0';
		}
		if(buf[i] >= 0x0a && buf[i] <= 0x0f)
		{
			buf[i] += ('A'-0x0a);
		}			
	}
	
	for( i = 3; i >= 0; i--) 
	{
	  while( !(SCI_STAT & SCI_STAT_TDRE) ){}
	  //dummy = SCI_STAT;
	  SCI_DATA  = buf[i];    		
	}
  
}//end TERMIO_Printdigit

/**
 * TERMIO_Init: This function initial the terminal. 
 *
 * Parameters:             void
 *
 * Subfunctions:           none.
 *
 * Return:                 void
 */ 

#pragma interrupt alignsp called
void rs485_init(uint32_t baudrate) 
{
	uint16_t	sbr;
	uint8_t	frac_sbr;
	
	/* Configure GPIOB6 and GPIOB7 as RXD and TXD */
	SIM_GPSB1 = 0;
	GPIOB_PER |= (GPIOB_PER_PER_6 | GPIOB_PER_PER_7);
	
	/* Enable clock to SCI */
	SIM_PCE |= SIM_PCE_SCI;
	
	sbr = (SCI_CLOCK_HZ>>4)/ baudrate;
	frac_sbr = ((SCI_CLOCK_HZ>>1)/baudrate - (sbr<<3)) & 0x7;
	SCI_RATE = (sbr<<3) | frac_sbr;
	
	#if 0 
	sSCI_CTRL1.TE = 1;		/* WARN: compiler uses little endian mode for structure
	                         *       but here the structure is defined as big endian mode
	                         */
	sSCI_CTRL1.RE = 1;	
	#endif
	SCI_CTRL1 = (SCI_CTRL1_TE | SCI_CTRL1_RE);
		
}//end TERMIO_Init








